package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ResolvedRecordsCount", 
    "ResolutionState"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_ActivateSdkMessageProcessingStepsResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResolvedRecordsCount")
    protected Integer resolvedRecordsCount;

    @JsonProperty("ResolutionState")
    protected Integer resolutionState;

    protected Msdyn_ActivateSdkMessageProcessingStepsResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingStepsResponse";
    }

    @Property(name="ResolvedRecordsCount")
    @JsonIgnore
    public Optional<Integer> getResolvedRecordsCount() {
        return Optional.ofNullable(resolvedRecordsCount);
    }

    public Msdyn_ActivateSdkMessageProcessingStepsResponse withResolvedRecordsCount(Integer resolvedRecordsCount) {
        Msdyn_ActivateSdkMessageProcessingStepsResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingStepsResponse");
        _x.resolvedRecordsCount = resolvedRecordsCount;
        return _x;
    }

    @Property(name="ResolutionState")
    @JsonIgnore
    public Optional<Integer> getResolutionState() {
        return Optional.ofNullable(resolutionState);
    }

    public Msdyn_ActivateSdkMessageProcessingStepsResponse withResolutionState(Integer resolutionState) {
        Msdyn_ActivateSdkMessageProcessingStepsResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingStepsResponse");
        _x.resolutionState = resolutionState;
        return _x;
    }

    public Msdyn_ActivateSdkMessageProcessingStepsResponse withUnmappedField(String name, String value) {
        Msdyn_ActivateSdkMessageProcessingStepsResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer resolvedRecordsCount;
        private Integer resolutionState;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder resolvedRecordsCount(Integer resolvedRecordsCount) {
            this.resolvedRecordsCount = resolvedRecordsCount;
            this.changedFields = changedFields.add("ResolvedRecordsCount");
            return this;
        }

        public Builder resolutionState(Integer resolutionState) {
            this.resolutionState = resolutionState;
            this.changedFields = changedFields.add("ResolutionState");
            return this;
        }

        public Msdyn_ActivateSdkMessageProcessingStepsResponse build() {
            Msdyn_ActivateSdkMessageProcessingStepsResponse _x = new Msdyn_ActivateSdkMessageProcessingStepsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingStepsResponse";
            _x.resolvedRecordsCount = resolvedRecordsCount;
            _x.resolutionState = resolutionState;
            return _x;
        }
    }

    private Msdyn_ActivateSdkMessageProcessingStepsResponse _copy() {
        Msdyn_ActivateSdkMessageProcessingStepsResponse _x = new Msdyn_ActivateSdkMessageProcessingStepsResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resolvedRecordsCount = resolvedRecordsCount;
        _x.resolutionState = resolutionState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_ActivateSdkMessageProcessingStepsResponse[");
        b.append("ResolvedRecordsCount=");
        b.append(this.resolvedRecordsCount);
        b.append(", ");
        b.append("ResolutionState=");
        b.append(this.resolutionState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
