package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.LogicalOperator;

@JsonPropertyOrder({
    "@odata.type", 
    "Conditions", 
    "FilterOperator", 
    "Filters"})
@JsonInclude(Include.NON_NULL)
public class MetadataFilterExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Conditions")
    protected List<MetadataConditionExpression> conditions;

    @JsonProperty("Conditions@nextLink")
    protected String conditionsNextLink;

    @JsonProperty("FilterOperator")
    protected LogicalOperator filterOperator;

    @JsonProperty("Filters")
    protected List<MetadataFilterExpression> filters;

    @JsonProperty("Filters@nextLink")
    protected String filtersNextLink;

    protected MetadataFilterExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataFilterExpression";
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<MetadataConditionExpression> getConditions() {
        return new CollectionPage<MetadataConditionExpression>(contextPath, MetadataConditionExpression.class, this.conditions, Optional.ofNullable(conditionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<MetadataConditionExpression> getConditions(HttpRequestOptions options) {
        return new CollectionPage<MetadataConditionExpression>(contextPath, MetadataConditionExpression.class, this.conditions, Optional.ofNullable(conditionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="FilterOperator")
    @JsonIgnore
    public Optional<LogicalOperator> getFilterOperator() {
        return Optional.ofNullable(filterOperator);
    }

    public MetadataFilterExpression withFilterOperator(LogicalOperator filterOperator) {
        MetadataFilterExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataFilterExpression");
        _x.filterOperator = filterOperator;
        return _x;
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<MetadataFilterExpression> getFilters() {
        return new CollectionPage<MetadataFilterExpression>(contextPath, MetadataFilterExpression.class, this.filters, Optional.ofNullable(filtersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<MetadataFilterExpression> getFilters(HttpRequestOptions options) {
        return new CollectionPage<MetadataFilterExpression>(contextPath, MetadataFilterExpression.class, this.filters, Optional.ofNullable(filtersNextLink), Collections.emptyList(), options);
    }

    public MetadataFilterExpression withUnmappedField(String name, String value) {
        MetadataFilterExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MetadataConditionExpression> conditions;
        private String conditionsNextLink;
        private LogicalOperator filterOperator;
        private List<MetadataFilterExpression> filters;
        private String filtersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder conditions(List<MetadataConditionExpression> conditions) {
            this.conditions = conditions;
            this.changedFields = changedFields.add("Conditions");
            return this;
        }

        public Builder conditions(MetadataConditionExpression... conditions) {
            return conditions(Arrays.asList(conditions));
        }

        public Builder conditionsNextLink(String conditionsNextLink) {
            this.conditionsNextLink = conditionsNextLink;
            this.changedFields = changedFields.add("Conditions");
            return this;
        }

        public Builder filterOperator(LogicalOperator filterOperator) {
            this.filterOperator = filterOperator;
            this.changedFields = changedFields.add("FilterOperator");
            return this;
        }

        public Builder filters(List<MetadataFilterExpression> filters) {
            this.filters = filters;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public Builder filters(MetadataFilterExpression... filters) {
            return filters(Arrays.asList(filters));
        }

        public Builder filtersNextLink(String filtersNextLink) {
            this.filtersNextLink = filtersNextLink;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public MetadataFilterExpression build() {
            MetadataFilterExpression _x = new MetadataFilterExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataFilterExpression";
            _x.conditions = conditions;
            _x.conditionsNextLink = conditionsNextLink;
            _x.filterOperator = filterOperator;
            _x.filters = filters;
            _x.filtersNextLink = filtersNextLink;
            return _x;
        }
    }

    private MetadataFilterExpression _copy() {
        MetadataFilterExpression _x = new MetadataFilterExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conditions = conditions;
        _x.filterOperator = filterOperator;
        _x.filters = filters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataFilterExpression[");
        b.append("Conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("FilterOperator=");
        b.append(this.filterOperator);
        b.append(", ");
        b.append("Filters=");
        b.append(this.filters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
