package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ExchangeFolderId", 
    "ExchangeFolderName", 
    "RegardingObjectId", 
    "RegardingObjectName", 
    "RegardingObjectTypeCode", 
    "IsFolderOnboarded"})
@JsonInclude(Include.NON_NULL)
public class MailboxTrackingFolderMapping implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ExchangeFolderId")
    protected String exchangeFolderId;

    @JsonProperty("ExchangeFolderName")
    protected String exchangeFolderName;

    @JsonProperty("RegardingObjectId")
    protected String regardingObjectId;

    @JsonProperty("RegardingObjectName")
    protected String regardingObjectName;

    @JsonProperty("RegardingObjectTypeCode")
    protected Integer regardingObjectTypeCode;

    @JsonProperty("IsFolderOnboarded")
    protected Boolean isFolderOnboarded;

    protected MailboxTrackingFolderMapping() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping";
    }

    @Property(name="ExchangeFolderId")
    @JsonIgnore
    public Optional<String> getExchangeFolderId() {
        return Optional.ofNullable(exchangeFolderId);
    }

    public MailboxTrackingFolderMapping withExchangeFolderId(String exchangeFolderId) {
        Checks.checkIsAscii(exchangeFolderId);
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.exchangeFolderId = exchangeFolderId;
        return _x;
    }

    @Property(name="ExchangeFolderName")
    @JsonIgnore
    public Optional<String> getExchangeFolderName() {
        return Optional.ofNullable(exchangeFolderName);
    }

    public MailboxTrackingFolderMapping withExchangeFolderName(String exchangeFolderName) {
        Checks.checkIsAscii(exchangeFolderName);
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.exchangeFolderName = exchangeFolderName;
        return _x;
    }

    @Property(name="RegardingObjectId")
    @JsonIgnore
    public Optional<String> getRegardingObjectId() {
        return Optional.ofNullable(regardingObjectId);
    }

    public MailboxTrackingFolderMapping withRegardingObjectId(String regardingObjectId) {
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.regardingObjectId = regardingObjectId;
        return _x;
    }

    @Property(name="RegardingObjectName")
    @JsonIgnore
    public Optional<String> getRegardingObjectName() {
        return Optional.ofNullable(regardingObjectName);
    }

    public MailboxTrackingFolderMapping withRegardingObjectName(String regardingObjectName) {
        Checks.checkIsAscii(regardingObjectName);
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.regardingObjectName = regardingObjectName;
        return _x;
    }

    @Property(name="RegardingObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getRegardingObjectTypeCode() {
        return Optional.ofNullable(regardingObjectTypeCode);
    }

    public MailboxTrackingFolderMapping withRegardingObjectTypeCode(Integer regardingObjectTypeCode) {
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.regardingObjectTypeCode = regardingObjectTypeCode;
        return _x;
    }

    @Property(name="IsFolderOnboarded")
    @JsonIgnore
    public Optional<Boolean> getIsFolderOnboarded() {
        return Optional.ofNullable(isFolderOnboarded);
    }

    public MailboxTrackingFolderMapping withIsFolderOnboarded(Boolean isFolderOnboarded) {
        MailboxTrackingFolderMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping");
        _x.isFolderOnboarded = isFolderOnboarded;
        return _x;
    }

    public MailboxTrackingFolderMapping withUnmappedField(String name, String value) {
        MailboxTrackingFolderMapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String exchangeFolderId;
        private String exchangeFolderName;
        private String regardingObjectId;
        private String regardingObjectName;
        private Integer regardingObjectTypeCode;
        private Boolean isFolderOnboarded;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder exchangeFolderId(String exchangeFolderId) {
            this.exchangeFolderId = exchangeFolderId;
            this.changedFields = changedFields.add("ExchangeFolderId");
            return this;
        }

        public Builder exchangeFolderName(String exchangeFolderName) {
            this.exchangeFolderName = exchangeFolderName;
            this.changedFields = changedFields.add("ExchangeFolderName");
            return this;
        }

        public Builder regardingObjectId(String regardingObjectId) {
            this.regardingObjectId = regardingObjectId;
            this.changedFields = changedFields.add("RegardingObjectId");
            return this;
        }

        public Builder regardingObjectName(String regardingObjectName) {
            this.regardingObjectName = regardingObjectName;
            this.changedFields = changedFields.add("RegardingObjectName");
            return this;
        }

        public Builder regardingObjectTypeCode(Integer regardingObjectTypeCode) {
            this.regardingObjectTypeCode = regardingObjectTypeCode;
            this.changedFields = changedFields.add("RegardingObjectTypeCode");
            return this;
        }

        public Builder isFolderOnboarded(Boolean isFolderOnboarded) {
            this.isFolderOnboarded = isFolderOnboarded;
            this.changedFields = changedFields.add("IsFolderOnboarded");
            return this;
        }

        public MailboxTrackingFolderMapping build() {
            MailboxTrackingFolderMapping _x = new MailboxTrackingFolderMapping();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MailboxTrackingFolderMapping";
            _x.exchangeFolderId = exchangeFolderId;
            _x.exchangeFolderName = exchangeFolderName;
            _x.regardingObjectId = regardingObjectId;
            _x.regardingObjectName = regardingObjectName;
            _x.regardingObjectTypeCode = regardingObjectTypeCode;
            _x.isFolderOnboarded = isFolderOnboarded;
            return _x;
        }
    }

    private MailboxTrackingFolderMapping _copy() {
        MailboxTrackingFolderMapping _x = new MailboxTrackingFolderMapping();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.exchangeFolderId = exchangeFolderId;
        _x.exchangeFolderName = exchangeFolderName;
        _x.regardingObjectId = regardingObjectId;
        _x.regardingObjectName = regardingObjectName;
        _x.regardingObjectTypeCode = regardingObjectTypeCode;
        _x.isFolderOnboarded = isFolderOnboarded;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailboxTrackingFolderMapping[");
        b.append("ExchangeFolderId=");
        b.append(this.exchangeFolderId);
        b.append(", ");
        b.append("ExchangeFolderName=");
        b.append(this.exchangeFolderName);
        b.append(", ");
        b.append("RegardingObjectId=");
        b.append(this.regardingObjectId);
        b.append(", ");
        b.append("RegardingObjectName=");
        b.append(this.regardingObjectName);
        b.append(", ");
        b.append("RegardingObjectTypeCode=");
        b.append(this.regardingObjectTypeCode);
        b.append(", ");
        b.append("IsFolderOnboarded=");
        b.append(this.isFolderOnboarded);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
