package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "FilterLanguages", 
    "MissingLabelBehavior"})
@JsonInclude(Include.NON_NULL)
public class LabelQueryExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FilterLanguages")
    protected List<Integer> filterLanguages;

    @JsonProperty("FilterLanguages@nextLink")
    protected String filterLanguagesNextLink;

    @JsonProperty("MissingLabelBehavior")
    protected Integer missingLabelBehavior;

    protected LabelQueryExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LabelQueryExpression";
    }

    @Property(name="FilterLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getFilterLanguages() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.filterLanguages, Optional.ofNullable(filterLanguagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="FilterLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getFilterLanguages(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.filterLanguages, Optional.ofNullable(filterLanguagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="MissingLabelBehavior")
    @JsonIgnore
    public Optional<Integer> getMissingLabelBehavior() {
        return Optional.ofNullable(missingLabelBehavior);
    }

    public LabelQueryExpression withMissingLabelBehavior(Integer missingLabelBehavior) {
        LabelQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LabelQueryExpression");
        _x.missingLabelBehavior = missingLabelBehavior;
        return _x;
    }

    public LabelQueryExpression withUnmappedField(String name, String value) {
        LabelQueryExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> filterLanguages;
        private String filterLanguagesNextLink;
        private Integer missingLabelBehavior;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder filterLanguages(List<Integer> filterLanguages) {
            this.filterLanguages = filterLanguages;
            this.changedFields = changedFields.add("FilterLanguages");
            return this;
        }

        public Builder filterLanguages(Integer... filterLanguages) {
            return filterLanguages(Arrays.asList(filterLanguages));
        }

        public Builder filterLanguagesNextLink(String filterLanguagesNextLink) {
            this.filterLanguagesNextLink = filterLanguagesNextLink;
            this.changedFields = changedFields.add("FilterLanguages");
            return this;
        }

        public Builder missingLabelBehavior(Integer missingLabelBehavior) {
            this.missingLabelBehavior = missingLabelBehavior;
            this.changedFields = changedFields.add("MissingLabelBehavior");
            return this;
        }

        public LabelQueryExpression build() {
            LabelQueryExpression _x = new LabelQueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LabelQueryExpression";
            _x.filterLanguages = filterLanguages;
            _x.filterLanguagesNextLink = filterLanguagesNextLink;
            _x.missingLabelBehavior = missingLabelBehavior;
            return _x;
        }
    }

    private LabelQueryExpression _copy() {
        LabelQueryExpression _x = new LabelQueryExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.filterLanguages = filterLanguages;
        _x.missingLabelBehavior = missingLabelBehavior;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LabelQueryExpression[");
        b.append("FilterLanguages=");
        b.append(this.filterLanguages);
        b.append(", ");
        b.append("MissingLabelBehavior=");
        b.append(this.missingLabelBehavior);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
