package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "FileContinuationToken", 
    "FileSizeInBytes", 
    "FileName"})
@JsonInclude(Include.NON_NULL)
public class InitializeAnnotationBlocksDownloadResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FileContinuationToken")
    protected String fileContinuationToken;

    @JsonProperty("FileSizeInBytes")
    protected Integer fileSizeInBytes;

    @JsonProperty("FileName")
    protected String fileName;

    protected InitializeAnnotationBlocksDownloadResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownloadResponse";
    }

    @Property(name="FileContinuationToken")
    @JsonIgnore
    public Optional<String> getFileContinuationToken() {
        return Optional.ofNullable(fileContinuationToken);
    }

    public InitializeAnnotationBlocksDownloadResponse withFileContinuationToken(String fileContinuationToken) {
        Checks.checkIsAscii(fileContinuationToken);
        InitializeAnnotationBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownloadResponse");
        _x.fileContinuationToken = fileContinuationToken;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Integer> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public InitializeAnnotationBlocksDownloadResponse withFileSizeInBytes(Integer fileSizeInBytes) {
        InitializeAnnotationBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownloadResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Property(name="FileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public InitializeAnnotationBlocksDownloadResponse withFileName(String fileName) {
        Checks.checkIsAscii(fileName);
        InitializeAnnotationBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownloadResponse");
        _x.fileName = fileName;
        return _x;
    }

    public InitializeAnnotationBlocksDownloadResponse withUnmappedField(String name, String value) {
        InitializeAnnotationBlocksDownloadResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fileContinuationToken;
        private Integer fileSizeInBytes;
        private String fileName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fileContinuationToken(String fileContinuationToken) {
            this.fileContinuationToken = fileContinuationToken;
            this.changedFields = changedFields.add("FileContinuationToken");
            return this;
        }

        public Builder fileSizeInBytes(Integer fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("FileName");
            return this;
        }

        public InitializeAnnotationBlocksDownloadResponse build() {
            InitializeAnnotationBlocksDownloadResponse _x = new InitializeAnnotationBlocksDownloadResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownloadResponse";
            _x.fileContinuationToken = fileContinuationToken;
            _x.fileSizeInBytes = fileSizeInBytes;
            _x.fileName = fileName;
            return _x;
        }
    }

    private InitializeAnnotationBlocksDownloadResponse _copy() {
        InitializeAnnotationBlocksDownloadResponse _x = new InitializeAnnotationBlocksDownloadResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fileContinuationToken = fileContinuationToken;
        _x.fileSizeInBytes = fileSizeInBytes;
        _x.fileName = fileName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InitializeAnnotationBlocksDownloadResponse[");
        b.append("FileContinuationToken=");
        b.append(this.fileContinuationToken);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append(", ");
        b.append("FileName=");
        b.append(this.fileName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
