package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityMetadata", 
    "AttributeNames", 
    "EntityClientSetting"})
@JsonInclude(Include.NON_NULL)
public class ClientEntityMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityMetadata")
    protected ComplexEntityMetadata entityMetadata;

    @JsonProperty("AttributeNames")
    protected List<String> attributeNames;

    @JsonProperty("AttributeNames@nextLink")
    protected String attributeNamesNextLink;

    @JsonProperty("EntityClientSetting")
    protected EntityClientSetting entityClientSetting;

    protected ClientEntityMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ClientEntityMetadata";
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public Optional<ComplexEntityMetadata> getEntityMetadata() {
        return Optional.ofNullable(entityMetadata);
    }

    public ClientEntityMetadata withEntityMetadata(ComplexEntityMetadata entityMetadata) {
        ClientEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ClientEntityMetadata");
        _x.entityMetadata = entityMetadata;
        return _x;
    }

    @Property(name="AttributeNames")
    @JsonIgnore
    public CollectionPage<String> getAttributeNames() {
        return new CollectionPage<String>(contextPath, String.class, this.attributeNames, Optional.ofNullable(attributeNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributeNames")
    @JsonIgnore
    public CollectionPage<String> getAttributeNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.attributeNames, Optional.ofNullable(attributeNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityClientSetting")
    @JsonIgnore
    public Optional<EntityClientSetting> getEntityClientSetting() {
        return Optional.ofNullable(entityClientSetting);
    }

    public ClientEntityMetadata withEntityClientSetting(EntityClientSetting entityClientSetting) {
        ClientEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ClientEntityMetadata");
        _x.entityClientSetting = entityClientSetting;
        return _x;
    }

    public ClientEntityMetadata withUnmappedField(String name, String value) {
        ClientEntityMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ComplexEntityMetadata entityMetadata;
        private List<String> attributeNames;
        private String attributeNamesNextLink;
        private EntityClientSetting entityClientSetting;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityMetadata(ComplexEntityMetadata entityMetadata) {
            this.entityMetadata = entityMetadata;
            this.changedFields = changedFields.add("EntityMetadata");
            return this;
        }

        public Builder attributeNames(List<String> attributeNames) {
            this.attributeNames = attributeNames;
            this.changedFields = changedFields.add("AttributeNames");
            return this;
        }

        public Builder attributeNames(String... attributeNames) {
            return attributeNames(Arrays.asList(attributeNames));
        }

        public Builder attributeNamesNextLink(String attributeNamesNextLink) {
            this.attributeNamesNextLink = attributeNamesNextLink;
            this.changedFields = changedFields.add("AttributeNames");
            return this;
        }

        public Builder entityClientSetting(EntityClientSetting entityClientSetting) {
            this.entityClientSetting = entityClientSetting;
            this.changedFields = changedFields.add("EntityClientSetting");
            return this;
        }

        public ClientEntityMetadata build() {
            ClientEntityMetadata _x = new ClientEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ClientEntityMetadata";
            _x.entityMetadata = entityMetadata;
            _x.attributeNames = attributeNames;
            _x.attributeNamesNextLink = attributeNamesNextLink;
            _x.entityClientSetting = entityClientSetting;
            return _x;
        }
    }

    private ClientEntityMetadata _copy() {
        ClientEntityMetadata _x = new ClientEntityMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityMetadata = entityMetadata;
        _x.attributeNames = attributeNames;
        _x.entityClientSetting = entityClientSetting;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientEntityMetadata[");
        b.append("EntityMetadata=");
        b.append(this.entityMetadata);
        b.append(", ");
        b.append("AttributeNames=");
        b.append(this.attributeNames);
        b.append(", ");
        b.append("EntityClientSetting=");
        b.append(this.entityClientSetting);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
