package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "MoreRecords", 
    "PagingCookie", 
    "DataToken", 
    "Changes", 
    "GlobalMetadataVersion"})
@JsonInclude(Include.NON_NULL)
public class BusinessEntityChanges implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MoreRecords")
    protected Boolean moreRecords;

    @JsonProperty("PagingCookie")
    protected String pagingCookie;

    @JsonProperty("DataToken")
    protected String dataToken;

    @JsonProperty("Changes")
    protected List<IChangedItem> changes;

    @JsonProperty("Changes@nextLink")
    protected String changesNextLink;

    @JsonProperty("GlobalMetadataVersion")
    protected String globalMetadataVersion;

    protected BusinessEntityChanges() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BusinessEntityChanges";
    }

    @Property(name="MoreRecords")
    @JsonIgnore
    public Optional<Boolean> getMoreRecords() {
        return Optional.ofNullable(moreRecords);
    }

    public BusinessEntityChanges withMoreRecords(Boolean moreRecords) {
        BusinessEntityChanges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.moreRecords = moreRecords;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(pagingCookie);
    }

    public BusinessEntityChanges withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii(pagingCookie);
        BusinessEntityChanges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Property(name="DataToken")
    @JsonIgnore
    public Optional<String> getDataToken() {
        return Optional.ofNullable(dataToken);
    }

    public BusinessEntityChanges withDataToken(String dataToken) {
        Checks.checkIsAscii(dataToken);
        BusinessEntityChanges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.dataToken = dataToken;
        return _x;
    }

    @Property(name="Changes")
    @JsonIgnore
    public CollectionPage<IChangedItem> getChanges() {
        return new CollectionPage<IChangedItem>(contextPath, IChangedItem.class, this.changes, Optional.ofNullable(changesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Changes")
    @JsonIgnore
    public CollectionPage<IChangedItem> getChanges(HttpRequestOptions options) {
        return new CollectionPage<IChangedItem>(contextPath, IChangedItem.class, this.changes, Optional.ofNullable(changesNextLink), Collections.emptyList(), options);
    }

    @Property(name="GlobalMetadataVersion")
    @JsonIgnore
    public Optional<String> getGlobalMetadataVersion() {
        return Optional.ofNullable(globalMetadataVersion);
    }

    public BusinessEntityChanges withGlobalMetadataVersion(String globalMetadataVersion) {
        Checks.checkIsAscii(globalMetadataVersion);
        BusinessEntityChanges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.globalMetadataVersion = globalMetadataVersion;
        return _x;
    }

    public BusinessEntityChanges withUnmappedField(String name, String value) {
        BusinessEntityChanges _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean moreRecords;
        private String pagingCookie;
        private String dataToken;
        private List<IChangedItem> changes;
        private String changesNextLink;
        private String globalMetadataVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder moreRecords(Boolean moreRecords) {
            this.moreRecords = moreRecords;
            this.changedFields = changedFields.add("MoreRecords");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = changedFields.add("PagingCookie");
            return this;
        }

        public Builder dataToken(String dataToken) {
            this.dataToken = dataToken;
            this.changedFields = changedFields.add("DataToken");
            return this;
        }

        public Builder changes(List<IChangedItem> changes) {
            this.changes = changes;
            this.changedFields = changedFields.add("Changes");
            return this;
        }

        public Builder changes(IChangedItem... changes) {
            return changes(Arrays.asList(changes));
        }

        public Builder changesNextLink(String changesNextLink) {
            this.changesNextLink = changesNextLink;
            this.changedFields = changedFields.add("Changes");
            return this;
        }

        public Builder globalMetadataVersion(String globalMetadataVersion) {
            this.globalMetadataVersion = globalMetadataVersion;
            this.changedFields = changedFields.add("GlobalMetadataVersion");
            return this;
        }

        public BusinessEntityChanges build() {
            BusinessEntityChanges _x = new BusinessEntityChanges();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BusinessEntityChanges";
            _x.moreRecords = moreRecords;
            _x.pagingCookie = pagingCookie;
            _x.dataToken = dataToken;
            _x.changes = changes;
            _x.changesNextLink = changesNextLink;
            _x.globalMetadataVersion = globalMetadataVersion;
            return _x;
        }
    }

    private BusinessEntityChanges _copy() {
        BusinessEntityChanges _x = new BusinessEntityChanges();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.moreRecords = moreRecords;
        _x.pagingCookie = pagingCookie;
        _x.dataToken = dataToken;
        _x.changes = changes;
        _x.globalMetadataVersion = globalMetadataVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessEntityChanges[");
        b.append("MoreRecords=");
        b.append(this.moreRecords);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append(", ");
        b.append("DataToken=");
        b.append(this.dataToken);
        b.append(", ");
        b.append("Changes=");
        b.append(this.changes);
        b.append(", ");
        b.append("GlobalMetadataVersion=");
        b.append(this.globalMetadataVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
