package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RibbonLocationFilters implements Enum {

    @JsonProperty("Form")
    FORM("Form", "1"),

    @JsonProperty("HomepageGrid")
    HOMEPAGE_GRID("HomepageGrid", "2"),

    @JsonProperty("SubGrid")
    SUB_GRID("SubGrid", "4"),

    @JsonProperty("All")
    ALL("All", "7");

    private final String name;
    private final String value;

    private RibbonLocationFilters(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
