package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointAccessType implements Enum {

    @JsonProperty("Default")
    DEFAULT("Default", "0"),

    @JsonProperty("Internet")
    INTERNET("Internet", "1"),

    @JsonProperty("Intranet")
    INTRANET("Intranet", "2");

    private final String name;
    private final String value;

    private EndpointAccessType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
