package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessRights implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("ReadAccess")
    READ_ACCESS("ReadAccess", "1"),

    @JsonProperty("WriteAccess")
    WRITE_ACCESS("WriteAccess", "2"),

    @JsonProperty("AppendAccess")
    APPEND_ACCESS("AppendAccess", "4"),

    @JsonProperty("AppendToAccess")
    APPEND_TO_ACCESS("AppendToAccess", "16"),

    @JsonProperty("CreateAccess")
    CREATE_ACCESS("CreateAccess", "32"),

    @JsonProperty("DeleteAccess")
    DELETE_ACCESS("DeleteAccess", "65536"),

    @JsonProperty("ShareAccess")
    SHARE_ACCESS("ShareAccess", "262144"),

    @JsonProperty("AssignAccess")
    ASSIGN_ACCESS("AssignAccess", "524288");

    private final String name;
    private final String value;

    private AccessRights(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
