package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Workflowlog;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class WorkflowlogRequest extends EntityRequest<Workflowlog> {

    public WorkflowlogRequest(ContextPath contextPath, Optional<Object> value) {
        super(Workflowlog.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public ProcesssessionRequest asyncoperationid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("asyncoperationid_processsession"), Optional.empty());
    }

    public ProcesssessionRequest childworkflowinstanceid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("childworkflowinstanceid_processsession"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest childworkflowinstanceid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("childworkflowinstanceid_asyncoperation"), Optional.empty());
    }

    public ExpiredprocessRequest expiredProcess_asyncoperationid() {
        return new ExpiredprocessRequest(contextPath.addSegment("ExpiredProcess_asyncoperationid"), Optional.empty());
    }

    public TranslationprocessRequest translationProcess_asyncoperationid() {
        return new TranslationprocessRequest(contextPath.addSegment("TranslationProcess_asyncoperationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public AsyncoperationRequest asyncoperationid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperationid_asyncoperation"), Optional.empty());
    }

    public NewprocessRequest newProcess_asyncoperationid() {
        return new NewprocessRequest(contextPath.addSegment("NewProcess_asyncoperationid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public FileattachmentCollectionRequest workflowlog_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("workflowlog_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest workflowlog_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("workflowlog_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

}
