package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Webresource;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class WebresourceRequest extends EntityRequest<Webresource> {

    public WebresourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Webresource.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SolutionCollectionRequest solution_configuration_webresource() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("solution_configuration_webresource"), Optional.empty());
    }

    public SolutionRequest solution_configuration_webresource(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("solution_configuration_webresource").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest webresource_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("webresource_userqueryvisualizations"), Optional.empty());
    }

    public UserqueryvisualizationRequest webresource_userqueryvisualizations(String userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("webresource_userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest webresource_savedqueryvisualizations() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("webresource_savedqueryvisualizations"), Optional.empty());
    }

    public SavedqueryvisualizationRequest webresource_savedqueryvisualizations(String savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("webresource_savedqueryvisualizations").addKeys(new NameValue(savedqueryvisualizationid.toString())), Optional.empty());
    }

    public ThemeCollectionRequest lk_theme_logoid() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_logoid"), Optional.empty());
    }

    public ThemeRequest lk_theme_logoid(String themeid) {
        return new ThemeRequest(contextPath.addSegment("lk_theme_logoid").addKeys(new NameValue(themeid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Webresource> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Webresource>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Webresource.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
