package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Usersettings;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class UsersettingsRequest extends EntityRequest<Usersettings> {

    public UsersettingsRequest(ContextPath contextPath, Optional<Object> value) {
        super(Usersettings.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest systemuserid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("systemuserid_systemuser"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest businessunitid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid_businessunit"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
