package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Systemform;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesstriggerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemformCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class SystemformRequest extends EntityRequest<Systemform> {

    public SystemformRequest(ContextPath contextPath, Optional<Object> value) {
        super(Systemform.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public AsyncoperationCollectionRequest systemForm_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SystemForm_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest systemForm_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SystemForm_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesstriggerCollectionRequest processtrigger_systemform() {
        return new ProcesstriggerCollectionRequest(
                        contextPath.addSegment("processtrigger_systemform"), Optional.empty());
    }

    public ProcesstriggerRequest processtrigger_systemform(String processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("processtrigger_systemform").addKeys(new NameValue(processtriggerid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest systemForm_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("SystemForm_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest systemForm_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SystemForm_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SystemformRequest ancestorformid() {
        return new SystemformRequest(contextPath.addSegment("ancestorformid"), Optional.empty());
    }

    public SystemformCollectionRequest form_ancestor_form() {
        return new SystemformCollectionRequest(
                        contextPath.addSegment("form_ancestor_form"), Optional.empty());
    }

    public SystemformRequest form_ancestor_form(String formid) {
        return new SystemformRequest(contextPath.addSegment("form_ancestor_form").addKeys(new NameValue(formid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    @Action(name = "CopySystemForm")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Systemform> copySystemForm(Systemform target) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.systemform", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Systemform>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CopySystemForm"), Systemform.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Systemform> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Systemform>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Systemform.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
