package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Kbarticle;
import microsoft.dynamics.crm.entity.Subject;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SubjectCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class SubjectRequest extends EntityRequest<Subject> {

    public SubjectRequest(ContextPath contextPath, Optional<Object> value) {
        super(Subject.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public ProcesssessionCollectionRequest subject_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Subject_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest subject_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Subject_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SubjectRequest parentsubject() {
        return new SubjectRequest(contextPath.addSegment("parentsubject"), Optional.empty());
    }

    public SubjectCollectionRequest subject_parent_subject() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("subject_parent_subject"), Optional.empty());
    }

    public SubjectRequest subject_parent_subject(String subjectid) {
        return new SubjectRequest(contextPath.addSegment("subject_parent_subject").addKeys(new NameValue(subjectid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AsyncoperationCollectionRequest subject_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Subject_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest subject_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Subject_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest subject_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Subject_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest subject_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Subject_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public KbarticleCollectionRequest subject_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("subject_kb_articles"), Optional.empty());
    }

    public KbarticleRequest subject_kb_articles(String kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("subject_kb_articles").addKeys(new NameValue(kbarticleid.toString())), Optional.empty());
    }

    public KnowledgearticleCollectionRequest subject_knowledgearticles() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("subject_knowledgearticles"), Optional.empty());
    }

    public KnowledgearticleRequest subject_knowledgearticles(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("subject_knowledgearticles").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest subject_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Subject_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest subject_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Subject_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest msdyn_subject_knowledgearticletemplate_subjectid() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("msdyn_subject_knowledgearticletemplate_subjectid"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest msdyn_subject_knowledgearticletemplate_subjectid(String msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("msdyn_subject_knowledgearticletemplate_subjectid").addKeys(new NameValue(msdyn_knowledgearticletemplateid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveByTopIncidentSubjectKbArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Kbarticle> retrieveByTopIncidentSubjectKbArticle() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveByTopIncidentSubjectKbArticle"), Kbarticle.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
