package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Socialactivity;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class SocialactivityRequest extends EntityRequest<Socialactivity> {

    public SocialactivityRequest(ContextPath contextPath, Optional<Object> value) {
        super(Socialactivity.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_socialactivity() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_socialactivity"), Optional.empty());
    }

    public ConnectionCollectionRequest socialactivity_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialactivity_connections2"), Optional.empty());
    }

    public ConnectionRequest socialactivity_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialactivity_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_socialactivity() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_socialactivity"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_socialactivity() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_socialactivity"), Optional.empty());
    }

    public AsyncoperationRequest regardingobjectid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("regardingobjectid_asyncoperation"), Optional.empty());
    }

    public ContactRequest postauthor_contact() {
        return new ContactRequest(contextPath.addSegment("postauthor_contact"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_socialactivity() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_socialactivity"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_socialactivity() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_socialactivity"), Optional.empty());
    }

    public ProcesssessionCollectionRequest socialActivity_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SocialActivity_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest socialActivity_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SocialActivity_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest socialActivity_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SocialActivity_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest socialActivity_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SocialActivity_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_socialactivity() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_socialactivity"), Optional.empty());
    }

    public ActivitypartyCollectionRequest socialactivity_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("socialactivity_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest socialactivity_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("socialactivity_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public TeamRequest owningteam_socialactivity() {
        return new TeamRequest(contextPath.addSegment("owningteam_socialactivity"), Optional.empty());
    }

    public SyncerrorCollectionRequest socialActivity_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SocialActivity_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest socialActivity_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SocialActivity_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_socialactivity() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_socialactivity"), Optional.empty());
    }

    public AccountRequest postauthoraccount_account() {
        return new AccountRequest(contextPath.addSegment("postauthoraccount_account"), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_socialactivity() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_socialactivity"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_socialactivity(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_socialactivity").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public ContactRequest postauthoraccount_contact() {
        return new ContactRequest(contextPath.addSegment("postauthoraccount_contact"), Optional.empty());
    }

    public SystemuserRequest createdby_socialactivity() {
        return new SystemuserRequest(contextPath.addSegment("createdby_socialactivity"), Optional.empty());
    }

    public SlaRequest sla_socialactivity_sla() {
        return new SlaRequest(contextPath.addSegment("sla_socialactivity_sla"), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest socialActivity_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("SocialActivity_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest socialActivity_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SocialActivity_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SocialprofileRequest postfromprofileid() {
        return new SocialprofileRequest(contextPath.addSegment("postfromprofileid"), Optional.empty());
    }

    public AccountRequest postauthor_account() {
        return new AccountRequest(contextPath.addSegment("postauthor_account"), Optional.empty());
    }

    public SystemuserRequest modifiedby_socialactivity() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_socialactivity"), Optional.empty());
    }

    public ConnectionCollectionRequest socialactivity_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialactivity_connections1"), Optional.empty());
    }

    public ConnectionRequest socialactivity_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialactivity_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest socialActivity_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("SocialActivity_Annotation"), Optional.empty());
    }

    public AnnotationRequest socialActivity_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("SocialActivity_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public SlaRequest slainvokedid_socialactivity_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_socialactivity_sla"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialActivity_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialActivity_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest socialActivity_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialActivity_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SystemuserRequest owninguser_socialactivity() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_socialactivity"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialActivity_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialActivity_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest socialActivity_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialActivity_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest socialActivity_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("SocialActivity_QueueItem"), Optional.empty());
    }

    public QueueitemRequest socialActivity_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("SocialActivity_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest socialactivity_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("socialactivity_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest socialactivity_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("socialactivity_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_socialactivity() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_socialactivity"), Optional.empty());
    }

    public PrincipalRequest ownerid_socialactivity() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_socialactivity"), Optional.empty());
    }

}
