package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Slakpiinstance;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class SlakpiinstanceRequest extends EntityRequest<Slakpiinstance> {

    public SlakpiinstanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Slakpiinstance.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public LetterRequest regarding_letter() {
        return new LetterRequest(contextPath.addSegment("regarding_letter"), Optional.empty());
    }

    public TaskRequest regarding_task() {
        return new TaskRequest(contextPath.addSegment("regarding_task"), Optional.empty());
    }

    public EmailRequest regarding_email() {
        return new EmailRequest(contextPath.addSegment("regarding_email"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SocialactivityRequest regarding_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regarding_socialactivity"), Optional.empty());
    }

    public AccountRequest regarding_account() {
        return new AccountRequest(contextPath.addSegment("regarding_account"), Optional.empty());
    }

    public AppointmentRequest regarding_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regarding_appointment"), Optional.empty());
    }

    public ContactRequest regarding_contact() {
        return new ContactRequest(contextPath.addSegment("regarding_contact"), Optional.empty());
    }

    public FaxRequest regarding_fax() {
        return new FaxRequest(contextPath.addSegment("regarding_fax"), Optional.empty());
    }

    public PhonecallRequest regarding_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regarding_phonecall"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public ActivitypointerRequest regarding_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("regarding_activitypointer"), Optional.empty());
    }

    public SyncerrorCollectionRequest sLAKPIInstance_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SLAKPIInstance_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest sLAKPIInstance_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLAKPIInstance_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SlaitemRequest msdyn_slaitemid() {
        return new SlaitemRequest(contextPath.addSegment("msdyn_slaitemid"), Optional.empty());
    }

}
