package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Savedquery;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class SavedqueryRequest extends EntityRequest<Savedquery> {

    public SavedqueryRequest(ContextPath contextPath, Optional<Object> value) {
        super(Savedquery.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorCollectionRequest savedQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SavedQuery_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest savedQuery_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SavedQuery_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest savedQuery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SavedQuery_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest savedQuery_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SavedQuery_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest savedQuery_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("SavedQuery_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest savedQuery_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SavedQuery_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest lk_mobileofflineprofileitem_savedquery() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitem_savedquery"), Optional.empty());
    }

    public MobileofflineprofileitemRequest lk_mobileofflineprofileitem_savedquery(String mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("lk_mobileofflineprofileitem_savedquery").addKeys(new NameValue(mobileofflineprofileitemid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Savedquery> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Savedquery>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Savedquery.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
