package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Quarterlyfiscalcalendar;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class QuarterlyfiscalcalendarRequest extends EntityRequest<Quarterlyfiscalcalendar> {

    public QuarterlyfiscalcalendarRequest(ContextPath contextPath, Optional<Object> value) {
        super(Quarterlyfiscalcalendar.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public AsyncoperationCollectionRequest quarterlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest quarterlyFiscalCalendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest quarterlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest quarterlyFiscalCalendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest salespersonid() {
        return new SystemuserRequest(contextPath.addSegment("salespersonid"), Optional.empty());
    }

}
