package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postregarding;
import microsoft.dynamics.crm.entity.collection.request.PostCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class PostregardingRequest extends EntityRequest<Postregarding> {

    public PostregardingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Postregarding.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public TaskRequest regardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), Optional.empty());
    }

    public AppointmentRequest regardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), Optional.empty());
    }

    public PhonecallRequest regardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), Optional.empty());
    }

    public RecurringappointmentmasterRequest regardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), Optional.empty());
    }

    public PostCollectionRequest post_PostRegardings() {
        return new PostCollectionRequest(
                        contextPath.addSegment("post_PostRegardings"), Optional.empty());
    }

    public PostRequest post_PostRegardings(String postid) {
        return new PostRequest(contextPath.addSegment("post_PostRegardings").addKeys(new NameValue(postid.toString())), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public SystemuserRequest regardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), Optional.empty());
    }

    public BusinessunitRequest regardingobjectowningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectowningbusinessunit"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), Optional.empty());
    }

    public TeamRequest regardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public QueueRequest regardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), Optional.empty());
    }

    public ProcesssessionRequest regardingobjectid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("regardingobjectid_processsession"), Optional.empty());
    }

}
