package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postlike;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class PostlikeRequest extends EntityRequest<Postlike> {

    public PostlikeRequest(ContextPath contextPath, Optional<Object> value) {
        super(Postlike.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public PostRequest postid() {
        return new PostRequest(contextPath.addSegment("postid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
