package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Post;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class PostRequest extends EntityRequest<Post> {

    public PostRequest(ContextPath contextPath, Optional<Object> value) {
        super(Post.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationCollectionRequest post_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("post_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest post_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("post_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest post_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("post_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest post_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("post_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PostregardingRequest postregardingid() {
        return new PostregardingRequest(contextPath.addSegment("postregardingid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public PostcommentCollectionRequest post_Comments() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("Post_Comments"), Optional.empty());
    }

    public PostcommentRequest post_Comments(String postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("Post_Comments").addKeys(new NameValue(postcommentid.toString())), Optional.empty());
    }

    public PostlikeCollectionRequest post_Likes() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("Post_Likes"), Optional.empty());
    }

    public PostlikeRequest post_Likes(String postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("Post_Likes").addKeys(new NameValue(postlikeid.toString())), Optional.empty());
    }

}
