package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Msdyn_aiodimage;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class Msdyn_aiodimageRequest extends EntityRequest<Msdyn_aiodimage> {

    public Msdyn_aiodimageRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_aiodimage.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aiodimage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_aiodimage_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aiodimage_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aiodimage_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aiodimage_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aiodimage_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aiodimage_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aiodimage_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aiodimage_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aiodimage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aiodimage_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aiodimage_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aiodimage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aiodimage_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aiodimage_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aiodimage_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aiodimage_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aiodimage_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aiodimage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aiodimage_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aiodimage_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aiodimage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aiodimage_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aiodimage_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest msdyn_aiodimage_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_Annotations"), Optional.empty());
    }

    public AnnotationRequest msdyn_aiodimage_Annotations(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("msdyn_aiodimage_Annotations").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest msdyn_aiodimage_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest msdyn_aiodimage_msdyn_aiodtrainingimage(String msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("msdyn_aiodimage_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid.toString())), Optional.empty());
    }

}
