package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Metric;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RollupfieldCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class MetricRequest extends EntityRequest<Metric> {

    public MetricRequest(ContextPath contextPath, Optional<Object> value) {
        super(Metric.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public GoalCollectionRequest metric_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("metric_goal"), Optional.empty());
    }

    public GoalRequest metric_goal(String goalid) {
        return new GoalRequest(contextPath.addSegment("metric_goal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public RollupfieldCollectionRequest metric_rollupfield() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("metric_rollupfield"), Optional.empty());
    }

    public RollupfieldRequest metric_rollupfield(String rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("metric_rollupfield").addKeys(new NameValue(rollupfieldid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest metric_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("metric_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest metric_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("metric_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest metric_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("metric_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest metric_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("metric_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest metric_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Metric_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest metric_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Metric_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
