package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Kbarticle;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticlecommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class KbarticleRequest extends EntityRequest<Kbarticle> {

    public KbarticleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Kbarticle.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AnnotationCollectionRequest kbArticle_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("KbArticle_Annotation"), Optional.empty());
    }

    public AnnotationRequest kbArticle_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("KbArticle_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticle_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest kbArticle_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticle_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest kbArticle_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticle_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest kbArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticle_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest kbArticle_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticle_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public KbarticletemplateRequest kbarticletemplateid() {
        return new KbarticletemplateRequest(contextPath.addSegment("kbarticletemplateid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest kbarticle_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("kbarticle_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest kbarticle_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("kbarticle_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest kbArticle_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("KbArticle_SharepointDocumentLocation"), Optional.empty());
    }

    public SharepointdocumentlocationRequest kbArticle_SharepointDocumentLocation(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("KbArticle_SharepointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public KbarticlecommentCollectionRequest kbarticle_comments() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("kbarticle_comments"), Optional.empty());
    }

    public KbarticlecommentRequest kbarticle_comments(String kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("kbarticle_comments").addKeys(new NameValue(kbarticlecommentid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest kbArticle_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KbArticle_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest kbArticle_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KbArticle_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SubjectRequest subjectid() {
        return new SubjectRequest(contextPath.addSegment("subjectid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
