package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Flowsession;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class FlowsessionRequest extends EntityRequest<Flowsession> {

    public FlowsessionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Flowsession.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorCollectionRequest flowsession_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("flowsession_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest flowsession_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("flowsession_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest flowsession_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("flowsession_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest flowsession_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("flowsession_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest flowsession_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("flowsession_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest flowsession_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("flowsession_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest flowsession_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("flowsession_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest flowsession_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("flowsession_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest flowsession_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("flowsession_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest flowsession_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("flowsession_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest flowsession_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("flowsession_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest flowsession_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("flowsession_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest flowsession_workflowbinary_FlowSessionId() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("flowsession_workflowbinary_FlowSessionId"), Optional.empty());
    }

    public WorkflowbinaryRequest flowsession_workflowbinary_FlowSessionId(String workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("flowsession_workflowbinary_FlowSessionId").addKeys(new NameValue(workflowbinaryid.toString())), Optional.empty());
    }

    public WorkflowRequest regardingobjectid_process() {
        return new WorkflowRequest(contextPath.addSegment("regardingobjectid_process"), Optional.empty());
    }

}
