package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.SendEmailResponse;
import microsoft.dynamics.crm.entity.Attachment;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Email;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class EmailRequest extends EntityRequest<Email> {

    public EmailRequest(ContextPath contextPath, Optional<Object> value) {
        super(Email.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_email() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_email"), Optional.empty());
    }

    public SyncerrorCollectionRequest email_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Email_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest email_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Email_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_email() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_email"), Optional.empty());
    }

    public AsyncoperationRequest regardingobjectid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("regardingobjectid_asyncoperation"), Optional.empty());
    }

    public AccountRequest sendersaccount() {
        return new AccountRequest(contextPath.addSegment("sendersaccount"), Optional.empty());
    }

    public AccountRequest emailsender_account() {
        return new AccountRequest(contextPath.addSegment("emailsender_account"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public SlaRequest sla_email_sla() {
        return new SlaRequest(contextPath.addSegment("sla_email_sla"), Optional.empty());
    }

    public AsyncoperationCollectionRequest email_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Email_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest email_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Email_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest email_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Email_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest email_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Email_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest email_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("email_connections1"), Optional.empty());
    }

    public ConnectionRequest email_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("email_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public MailboxRequest sendermailboxid_email() {
        return new MailboxRequest(contextPath.addSegment("sendermailboxid_email"), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest email_activity_mime_attachment() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("email_activity_mime_attachment"), Optional.empty());
    }

    public ActivitymimeattachmentRequest email_activity_mime_attachment(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("email_activity_mime_attachment").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_email() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_email"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_email(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_email").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest email_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("email_connections2"), Optional.empty());
    }

    public ConnectionRequest email_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("email_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_email() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_email"), Optional.empty());
    }

    public ContactRequest emailsender_contact() {
        return new ContactRequest(contextPath.addSegment("emailsender_contact"), Optional.empty());
    }

    public SystemuserRequest owninguser_email() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_email"), Optional.empty());
    }

    public SystemuserRequest modifiedby_email() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_email"), Optional.empty());
    }

    public TeamRequest owningteam_email() {
        return new TeamRequest(contextPath.addSegment("owningteam_email"), Optional.empty());
    }

    public QueueRequest emailsender_queue() {
        return new QueueRequest(contextPath.addSegment("emailsender_queue"), Optional.empty());
    }

    public SlaRequest slainvokedid_email_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_email_sla"), Optional.empty());
    }

    public AnnotationCollectionRequest email_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Email_Annotation"), Optional.empty());
    }

    public AnnotationRequest email_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Email_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest email_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Email_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest email_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Email_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest email_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Email_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest email_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Email_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_email() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_email"), Optional.empty());
    }

    public ActivitypartyCollectionRequest email_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("email_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest email_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("email_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_email() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_email"), Optional.empty());
    }

    public ActioncardCollectionRequest email_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("email_actioncard"), Optional.empty());
    }

    public ActioncardRequest email_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("email_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest email_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Email_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest email_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Email_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest email_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("email_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest email_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("email_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_email() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_email"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_email() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_email"), Optional.empty());
    }

    public SystemuserRequest createdby_email() {
        return new SystemuserRequest(contextPath.addSegment("createdby_email"), Optional.empty());
    }

    public SystemuserRequest emailsender_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("emailsender_systemuser"), Optional.empty());
    }

    public TemplateRequest templateid() {
        return new TemplateRequest(contextPath.addSegment("templateid"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_email() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_email"), Optional.empty());
    }

    public QueueitemCollectionRequest email_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("Email_QueueItem"), Optional.empty());
    }

    public QueueitemRequest email_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Email_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public EmailRequest parentactivityid() {
        return new EmailRequest(contextPath.addSegment("parentactivityid"), Optional.empty());
    }

    public EmailCollectionRequest email_email_parentactivityid() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("email_email_parentactivityid"), Optional.empty());
    }

    public EmailRequest email_email_parentactivityid(String activityid) {
        return new EmailRequest(contextPath.addSegment("email_email_parentactivityid").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid_email() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_email"), Optional.empty());
    }

    @Action(name = "DeliverImmediatePromoteEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Email> deliverImmediatePromoteEmail(String messageId, String subject, String from, String to, String cc, String bcc, OffsetDateTime receivedOn, String submittedBy, String importance, String body, List<String> attachmentIds, String eWSUrl, String attachmentToken, Crmbaseentity extraProperties) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(from, "from cannot be null");
        Preconditions.checkNotNull(to, "to cannot be null");
        Preconditions.checkNotNull(cc, "cc cannot be null");
        Preconditions.checkNotNull(bcc, "bcc cannot be null");
        Preconditions.checkNotNull(receivedOn, "receivedOn cannot be null");
        Preconditions.checkNotNull(submittedBy, "submittedBy cannot be null");
        Preconditions.checkNotNull(importance, "importance cannot be null");
        Preconditions.checkNotNull(body, "body cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("From", "Edm.String", Checks.checkIsAscii(from))
            .put("To", "Edm.String", Checks.checkIsAscii(to))
            .put("Cc", "Edm.String", Checks.checkIsAscii(cc))
            .put("Bcc", "Edm.String", Checks.checkIsAscii(bcc))
            .put("ReceivedOn", "Edm.DateTimeOffset", receivedOn)
            .put("SubmittedBy", "Edm.String", Checks.checkIsAscii(submittedBy))
            .put("Importance", "Edm.String", Checks.checkIsAscii(importance))
            .put("Body", "Edm.String", Checks.checkIsAscii(body))
            .put("AttachmentIds", "Collection(Edm.String)", Checks.checkIsAscii(attachmentIds))
            .put("EWSUrl", "Edm.String", Checks.checkIsAscii(eWSUrl))
            .put("AttachmentToken", "Edm.String", Checks.checkIsAscii(attachmentToken))
            .put("ExtraProperties", "Microsoft.Dynamics.CRM.crmbaseentity", extraProperties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Email>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeliverImmediatePromoteEmail"), Email.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "DeliverPromoteEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Email> deliverPromoteEmail(String messageId, String subject, String from, String to, String cc, String bcc, OffsetDateTime receivedOn, String submittedBy, String importance, String body, List<Attachment> attachments, Crmbaseentity extraProperties) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(from, "from cannot be null");
        Preconditions.checkNotNull(to, "to cannot be null");
        Preconditions.checkNotNull(cc, "cc cannot be null");
        Preconditions.checkNotNull(bcc, "bcc cannot be null");
        Preconditions.checkNotNull(receivedOn, "receivedOn cannot be null");
        Preconditions.checkNotNull(submittedBy, "submittedBy cannot be null");
        Preconditions.checkNotNull(importance, "importance cannot be null");
        Preconditions.checkNotNull(body, "body cannot be null");
        Preconditions.checkNotNull(attachments, "attachments cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("From", "Edm.String", Checks.checkIsAscii(from))
            .put("To", "Edm.String", Checks.checkIsAscii(to))
            .put("Cc", "Edm.String", Checks.checkIsAscii(cc))
            .put("Bcc", "Edm.String", Checks.checkIsAscii(bcc))
            .put("ReceivedOn", "Edm.DateTimeOffset", receivedOn)
            .put("SubmittedBy", "Edm.String", Checks.checkIsAscii(submittedBy))
            .put("Importance", "Edm.String", Checks.checkIsAscii(importance))
            .put("Body", "Edm.String", Checks.checkIsAscii(body))
            .put("Attachments", "Collection(Microsoft.Dynamics.CRM.attachment)", attachments)
            .put("ExtraProperties", "Microsoft.Dynamics.CRM.crmbaseentity", extraProperties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Email>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeliverPromoteEmail"), Email.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "SendEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SendEmailResponse> sendEmail(Boolean issueSend, String trackingToken) {
        Preconditions.checkNotNull(issueSend, "issueSend cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("IssueSend", "Edm.Boolean", issueSend)
            .put("TrackingToken", "Edm.String", Checks.checkIsAscii(trackingToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SendEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendEmail"), SendEmailResponse.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
