package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Duplicaterulecondition;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class DuplicateruleconditionRequest extends EntityRequest<Duplicaterulecondition> {

    public DuplicateruleconditionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Duplicaterulecondition.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SyncerrorCollectionRequest duplicateRuleCondition_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("DuplicateRuleCondition_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest duplicateRuleCondition_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicateruleRequest regardingobjectid() {
        return new DuplicateruleRequest(contextPath.addSegment("regardingobjectid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
