package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Dataperformance;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class DataperformanceRequest extends EntityRequest<Dataperformance> {

    public DataperformanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Dataperformance.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
