package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Customcontrol;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolresourceCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class CustomcontrolRequest extends EntityRequest<Customcontrol> {

    public CustomcontrolRequest(ContextPath contextPath, Optional<Object> value) {
        super(Customcontrol.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest customcontrol_resource_id() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("customcontrol_resource_id"), Optional.empty());
    }

    public CustomcontrolresourceRequest customcontrol_resource_id(String customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrol_resource_id").addKeys(new NameValue(customcontrolresourceid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

}
