package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Contact;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomeraddressCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class ContactRequest extends EntityRequest<Contact> {

    public ContactRequest(ContextPath contextPath, Optional<Object> value) {
        super(Contact.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public PrincipalobjectattributeaccessCollectionRequest contact_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("contact_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest contact_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("contact_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest contact_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("contact_connections1"), Optional.empty());
    }

    public ConnectionRequest contact_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("contact_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public FeedbackCollectionRequest contact_Feedback() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("Contact_Feedback"), Optional.empty());
    }

    public FeedbackRequest contact_Feedback(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("Contact_Feedback").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest contact_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Contact_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest contact_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Contact_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public ActivitypointerCollectionRequest contact_ActivityPointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("Contact_ActivityPointers"), Optional.empty());
    }

    public ActivitypointerRequest contact_ActivityPointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("Contact_ActivityPointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest contact_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("Contact_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest contact_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Contact_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public FeedbackCollectionRequest lk_contact_feedback_createdonbehalfby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_contact_feedback_createdonbehalfby"), Optional.empty());
    }

    public FeedbackRequest lk_contact_feedback_createdonbehalfby(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_contact_feedback_createdonbehalfby").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest contact_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("contact_PostFollows"), Optional.empty());
    }

    public PostfollowRequest contact_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("contact_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest contact_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("contact_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest contact_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("contact_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialactivity_postauthor_contacts() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("socialactivity_postauthor_contacts"), Optional.empty());
    }

    public SocialactivityRequest socialactivity_postauthor_contacts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("socialactivity_postauthor_contacts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest contact_Phonecalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("Contact_Phonecalls"), Optional.empty());
    }

    public PhonecallRequest contact_Phonecalls(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("Contact_Phonecalls").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public TaskCollectionRequest contact_Tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("Contact_Tasks"), Optional.empty());
    }

    public TaskRequest contact_Tasks(String activityid) {
        return new TaskRequest(contextPath.addSegment("Contact_Tasks").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest contact_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Contact_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest contact_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Contact_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SlaRequest slainvokedid_contact_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_contact_sla"), Optional.empty());
    }

    public SlaRequest sla_contact_sla() {
        return new SlaRequest(contextPath.addSegment("sla_contact_sla"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AnnotationCollectionRequest contact_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Contact_Annotation"), Optional.empty());
    }

    public AnnotationRequest contact_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Contact_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public ContactRequest masterid() {
        return new ContactRequest(contextPath.addSegment("masterid"), Optional.empty());
    }

    public ContactCollectionRequest contact_master_contact() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contact_master_contact"), Optional.empty());
    }

    public ContactRequest contact_master_contact(String contactid) {
        return new ContactRequest(contextPath.addSegment("contact_master_contact").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public EmailCollectionRequest contact_Email_EmailSender() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Contact_Email_EmailSender"), Optional.empty());
    }

    public EmailRequest contact_Email_EmailSender(String activityid) {
        return new EmailRequest(contextPath.addSegment("Contact_Email_EmailSender").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountCollectionRequest account_primary_contact() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("account_primary_contact"), Optional.empty());
    }

    public AccountRequest account_primary_contact(String accountid) {
        return new AccountRequest(contextPath.addSegment("account_primary_contact").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ActioncardCollectionRequest contact_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("contact_actioncard"), Optional.empty());
    }

    public ActioncardRequest contact_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("contact_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialactivity_postauthoraccount_contacts() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("socialactivity_postauthoraccount_contacts"), Optional.empty());
    }

    public SocialactivityRequest socialactivity_postauthoraccount_contacts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("socialactivity_postauthoraccount_contacts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialprofileCollectionRequest socialprofile_customer_contacts() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("Socialprofile_customer_contacts"), Optional.empty());
    }

    public SocialprofileRequest socialprofile_customer_contacts(String socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("Socialprofile_customer_contacts").addKeys(new NameValue(socialprofileid.toString())), Optional.empty());
    }

    public CustomeraddressCollectionRequest contact_CustomerAddress() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("Contact_CustomerAddress"), Optional.empty());
    }

    public CustomeraddressRequest contact_CustomerAddress(String customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("Contact_CustomerAddress").addKeys(new NameValue(customeraddressid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public AccountRequest parentcustomerid_account() {
        return new AccountRequest(contextPath.addSegment("parentcustomerid_account"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest contact_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Contact_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest contact_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Contact_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public FeedbackCollectionRequest lk_contact_feedback_createdby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_contact_feedback_createdby"), Optional.empty());
    }

    public FeedbackRequest lk_contact_feedback_createdby(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_contact_feedback_createdby").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_contact() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_contact"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_contact(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_contact").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public SystemuserRequest preferredsystemuserid() {
        return new SystemuserRequest(contextPath.addSegment("preferredsystemuserid"), Optional.empty());
    }

    public FaxCollectionRequest contact_Faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("Contact_Faxes"), Optional.empty());
    }

    public FaxRequest contact_Faxes(String activityid) {
        return new FaxRequest(contextPath.addSegment("Contact_Faxes").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest contact_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("Contact_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest contact_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Contact_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest contact_Appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("Contact_Appointments"), Optional.empty());
    }

    public AppointmentRequest contact_Appointments(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("Contact_Appointments").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public AsyncoperationCollectionRequest contact_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Contact_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest contact_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Contact_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest contact_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("Contact_RecurringAppointmentMasters"), Optional.empty());
    }

    public RecurringappointmentmasterRequest contact_RecurringAppointmentMasters(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("Contact_RecurringAppointmentMasters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest contact_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Contact_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest contact_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Contact_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public ContactRequest parentcustomerid_contact() {
        return new ContactRequest(contextPath.addSegment("parentcustomerid_contact"), Optional.empty());
    }

    public ContactCollectionRequest contact_customer_contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contact_customer_contacts"), Optional.empty());
    }

    public ContactRequest contact_customer_contacts(String contactid) {
        return new ContactRequest(contextPath.addSegment("contact_customer_contacts").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest contact_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("contact_connections2"), Optional.empty());
    }

    public ConnectionRequest contact_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("contact_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest contact_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Contact_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest contact_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Contact_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public EmailCollectionRequest contact_Emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Contact_Emails"), Optional.empty());
    }

    public EmailRequest contact_Emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("Contact_Emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest contact_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("contact_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest contact_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("contact_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public LetterCollectionRequest contact_Letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("Contact_Letters"), Optional.empty());
    }

    public LetterRequest contact_Letters(String activityid) {
        return new LetterRequest(contextPath.addSegment("Contact_Letters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

}
