package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Connectionrole;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class ConnectionroleRequest extends EntityRequest<Connectionrole> {

    public ConnectionroleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Connectionrole.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ProcesssessionCollectionRequest connectionRole_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ConnectionRole_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest connectionRole_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ConnectionRole_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationCollectionRequest connection_Role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Connection_Role_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest connection_Role_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Connection_Role_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections2"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest connectionRole_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ConnectionRole_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest connectionRole_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ConnectionRole_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections1"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association_referenced() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association_referenced"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association_referenced(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association_referenced").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
