package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Complexcontrol;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class ComplexcontrolRequest extends EntityRequest<Complexcontrol> {

    public ComplexcontrolRequest(ContextPath contextPath, Optional<Object> value) {
        super(Complexcontrol.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
