package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Columnmapping;
import microsoft.dynamics.crm.entity.collection.request.LookupmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PicklistmappingCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class ColumnmappingRequest extends EntityRequest<Columnmapping> {

    public ColumnmappingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Columnmapping.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public PicklistmappingCollectionRequest pickListMapping_ColumnMapping() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("PickListMapping_ColumnMapping"), Optional.empty());
    }

    public PicklistmappingRequest pickListMapping_ColumnMapping(String picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("PickListMapping_ColumnMapping").addKeys(new NameValue(picklistmappingid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public ImportmapRequest importmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public LookupmappingCollectionRequest lookUpMapping_ColumnMapping() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("LookUpMapping_ColumnMapping"), Optional.empty());
    }

    public LookupmappingRequest lookUpMapping_ColumnMapping(String lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("LookUpMapping_ColumnMapping").addKeys(new NameValue(lookupmappingid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
