package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attachment;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class AttachmentRequest extends EntityRequest<Attachment> {

    public AttachmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Attachment.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SyncerrorCollectionRequest attachment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Attachment_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest attachment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Attachment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest attachment_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("attachment_activity_mime_attachments"), Optional.empty());
    }

    public ActivitymimeattachmentRequest attachment_activity_mime_attachments(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("attachment_activity_mime_attachments").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

}
