package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Activitymimeattachment;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonIgnoreType
public class ActivitymimeattachmentRequest extends EntityRequest<Activitymimeattachment> {

    public ActivitymimeattachmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Activitymimeattachment.class, contextPath, SchemaInfo.INSTANCE, value);
    }

    public SyncerrorCollectionRequest activityMimeAttachment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ActivityMimeAttachment_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest activityMimeAttachment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ActivityMimeAttachment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public EmailRequest objectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), Optional.empty());
    }

    public ActivitypointerRequest objectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("objectid_activitypointer"), Optional.empty());
    }

    public TemplateRequest objectid_template() {
        return new TemplateRequest(contextPath.addSegment("objectid_template"), Optional.empty());
    }

    public AttachmentRequest attachmentid() {
        return new AttachmentRequest(contextPath.addSegment("attachmentid"), Optional.empty());
    }

    public AppointmentRequest objectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), Optional.empty());
    }

    public AsyncoperationCollectionRequest activityMimeAttachment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ActivityMimeAttachment_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest activityMimeAttachment_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ActivityMimeAttachment_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest activityMimeAttachment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ActivityMimeAttachment_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest activityMimeAttachment_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ActivityMimeAttachment_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
