package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Workflowlog;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class WorkflowlogCollectionRequest extends CollectionPageEntityRequest<Workflowlog, WorkflowlogRequest>{

    protected ContextPath contextPath;

    public WorkflowlogCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Workflowlog.class, cp -> new WorkflowlogRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public FileattachmentCollectionRequest workflowlog_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("workflowlog_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest workflowlog_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("workflowlog_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

}
