package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Webwizard;
import microsoft.dynamics.crm.entity.request.WebwizardRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class WebwizardCollectionRequest extends CollectionPageEntityRequest<Webwizard, WebwizardRequest>{

    protected ContextPath contextPath;

    public WebwizardCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Webwizard.class, cp -> new WebwizardRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
