package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Usersettings;
import microsoft.dynamics.crm.entity.request.UsersettingsRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class UsersettingsCollectionRequest extends CollectionPageEntityRequest<Usersettings, UsersettingsRequest>{

    protected ContextPath contextPath;

    public UsersettingsCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Usersettings.class, cp -> new UsersettingsRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
