package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Translationprocess;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class TranslationprocessCollectionRequest extends CollectionPageEntityRequest<Translationprocess, TranslationprocessRequest>{

    protected ContextPath contextPath;

    public TranslationprocessCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Translationprocess.class, cp -> new TranslationprocessRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest translationProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("TranslationProcess_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest translationProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("TranslationProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_translationprocess() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("workflowlogs_translationprocess"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_translationprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_translationprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest translationProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("TranslationProcess_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest translationProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("TranslationProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

}
