package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Tracelog;
import microsoft.dynamics.crm.entity.request.TracelogRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class TracelogCollectionRequest extends CollectionPageEntityRequest<Tracelog, TracelogRequest>{

    protected ContextPath contextPath;

    public TracelogCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Tracelog.class, cp -> new TracelogRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public TracelogCollectionRequest tracelog_parent_tracelog() {
        return new TracelogCollectionRequest(contextPath.addSegment("tracelog_parent_tracelog"), Optional.empty());
    }

    public TracelogRequest tracelog_parent_tracelog(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_parent_tracelog").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

}
