package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Timezonerule;
import microsoft.dynamics.crm.entity.request.TimezoneruleRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class TimezoneruleCollectionRequest extends CollectionPageEntityRequest<Timezonerule, TimezoneruleRequest>{

    protected ContextPath contextPath;

    public TimezoneruleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Timezonerule.class, cp -> new TimezoneruleRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
