package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Territory;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class TerritoryCollectionRequest extends CollectionPageEntityRequest<Territory, TerritoryRequest>{

    protected ContextPath contextPath;

    public TerritoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Territory.class, cp -> new TerritoryRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest territory_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Territory_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest territory_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Territory_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest territory_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Territory_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest territory_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Territory_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest territory_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("territory_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest territory_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("territory_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest territory_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Territory_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest territory_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Territory_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest territory_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Territory_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest territory_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Territory_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest territory_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("territory_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest territory_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("territory_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest territory_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("territory_connections1"), Optional.empty());
    }

    public ConnectionRequest territory_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("territory_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest territory_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("territory_connections2"), Optional.empty());
    }

    public ConnectionRequest territory_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("territory_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest territory_system_users() {
        return new SystemuserCollectionRequest(contextPath.addSegment("territory_system_users"), Optional.empty());
    }

    public SystemuserRequest territory_system_users(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("territory_system_users").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public TerritoryCollectionRequest territory_parent_territory() {
        return new TerritoryCollectionRequest(contextPath.addSegment("territory_parent_territory"), Optional.empty());
    }

    public TerritoryRequest territory_parent_territory(String territoryid) {
        return new TerritoryRequest(contextPath.addSegment("territory_parent_territory").addKeys(new NameValue(territoryid.toString())), Optional.empty());
    }

}
