package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Solutioncomponentconfiguration;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SolutioncomponentconfigurationCollectionRequest extends CollectionPageEntityRequest<Solutioncomponentconfiguration, SolutioncomponentconfigurationRequest>{

    protected ContextPath contextPath;

    public SolutioncomponentconfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Solutioncomponentconfiguration.class, cp -> new SolutioncomponentconfigurationRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest solutioncomponentconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest solutioncomponentconfiguration_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("solutioncomponentconfiguration_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentconfiguration_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentconfiguration_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest solutioncomponentconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest solutioncomponentconfiguration_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("solutioncomponentconfiguration_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest solutioncomponentconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest solutioncomponentconfiguration_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("solutioncomponentconfiguration_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest solutioncomponentconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest solutioncomponentconfiguration_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("solutioncomponentconfiguration_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest solutioncomponentconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest solutioncomponentconfiguration_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("solutioncomponentconfiguration_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest solutioncomponentconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest solutioncomponentconfiguration_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("solutioncomponentconfiguration_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest solutioncomponentconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("solutioncomponentconfiguration_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest solutioncomponentconfiguration_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("solutioncomponentconfiguration_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest solutioncomponentconfig_solutioncomponentattrconfig() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(contextPath.addSegment("solutioncomponentconfig_solutioncomponentattrconfig"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest solutioncomponentconfig_solutioncomponentattrconfig(String solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("solutioncomponentconfig_solutioncomponentattrconfig").addKeys(new NameValue(solutioncomponentattributeconfigurationid.toString())), Optional.empty());
    }

}
