package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.ExportTranslationResponse;
import microsoft.dynamics.crm.entity.Solution;
import microsoft.dynamics.crm.entity.request.CanvasappRequest;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SolutionCollectionRequest extends CollectionPageEntityRequest<Solution, SolutionRequest>{

    protected ContextPath contextPath;

    public SolutionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Solution.class, cp -> new SolutionRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SolutioncomponentCollectionRequest solution_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(contextPath.addSegment("solution_solutioncomponent"), Optional.empty());
    }

    public SolutioncomponentRequest solution_solutioncomponent(String solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solution_solutioncomponent").addKeys(new NameValue(solutioncomponentid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest solution_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Solution_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest solution_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Solution_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SolutionCollectionRequest solution_parent_solution() {
        return new SolutionCollectionRequest(contextPath.addSegment("solution_parent_solution"), Optional.empty());
    }

    public SolutionRequest solution_parent_solution(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("solution_parent_solution").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest regardingobjectid_fileattachment_solution() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("regardingobjectid_fileattachment_solution"), Optional.empty());
    }

    public FileattachmentRequest regardingobjectid_fileattachment_solution(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("regardingobjectid_fileattachment_solution").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public CanvasappCollectionRequest fK_CanvasApp_Solution() {
        return new CanvasappCollectionRequest(contextPath.addSegment("FK_CanvasApp_Solution"), Optional.empty());
    }

    public CanvasappRequest fK_CanvasApp_Solution(String canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("FK_CanvasApp_Solution").addKeys(new NameValue(canvasappid.toString())), Optional.empty());
    }

    public FieldpermissionCollectionRequest solution_fieldpermission() {
        return new FieldpermissionCollectionRequest(contextPath.addSegment("solution_fieldpermission"), Optional.empty());
    }

    public FieldpermissionRequest solution_fieldpermission(String fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("solution_fieldpermission").addKeys(new NameValue(fieldpermissionid.toString())), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest solution_fieldsecurityprofile() {
        return new FieldsecurityprofileCollectionRequest(contextPath.addSegment("solution_fieldsecurityprofile"), Optional.empty());
    }

    public FieldsecurityprofileRequest solution_fieldsecurityprofile(String fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("solution_fieldsecurityprofile").addKeys(new NameValue(fieldsecurityprofileid.toString())), Optional.empty());
    }

    public PrivilegeCollectionRequest solution_privilege() {
        return new PrivilegeCollectionRequest(contextPath.addSegment("solution_privilege"), Optional.empty());
    }

    public PrivilegeRequest solution_privilege(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("solution_privilege").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public RoleCollectionRequest solution_role() {
        return new RoleCollectionRequest(contextPath.addSegment("solution_role"), Optional.empty());
    }

    public RoleRequest solution_role(String roleid) {
        return new RoleRequest(contextPath.addSegment("solution_role").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    @Action(name = "ExportTranslation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportTranslationResponse> exportTranslation(String solutionName) {
        Preconditions.checkNotNull(solutionName, "solutionName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionName", "Edm.String", Checks.checkIsAscii(solutionName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportTranslationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportTranslation"), ExportTranslationResponse.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
