package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Slaitem;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SlaitemCollectionRequest extends CollectionPageEntityRequest<Slaitem, SlaitemRequest>{

    protected ContextPath contextPath;

    public SlaitemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Slaitem.class, cp -> new SlaitemRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest sLAItem_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SLAItem_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest sLAItem_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLAItem_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest msdyn_slaitem_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("msdyn_slaitem_slakpiinstance"), Optional.empty());
    }

    public SlakpiinstanceRequest msdyn_slaitem_slakpiinstance(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("msdyn_slaitem_slakpiinstance").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

}
