package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sdkmessagefilter;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SdkmessagefilterCollectionRequest extends CollectionPageEntityRequest<Sdkmessagefilter, SdkmessagefilterRequest>{

    protected ContextPath contextPath;

    public SdkmessagefilterCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sdkmessagefilter.class, cp -> new SdkmessagefilterRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SdkmessageprocessingstepCollectionRequest sdkmessagefilterid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("sdkmessagefilterid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest sdkmessagefilterid_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessagefilterid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

}
