package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sdkmessage;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SdkmessageCollectionRequest extends CollectionPageEntityRequest<Sdkmessage, SdkmessageRequest>{

    protected ContextPath contextPath;

    public SdkmessageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sdkmessage.class, cp -> new SdkmessageRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SdkmessageprocessingstepCollectionRequest sdkmessageid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("sdkmessageid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest sdkmessageid_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessageid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest sdkmessageid_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(contextPath.addSegment("sdkmessageid_sdkmessagefilter"), Optional.empty());
    }

    public SdkmessagefilterRequest sdkmessageid_sdkmessagefilter(String sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessageid_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid.toString())), Optional.empty());
    }

}
