package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Runtimedependency;
import microsoft.dynamics.crm.entity.request.RuntimedependencyRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RuntimedependencyCollectionRequest extends CollectionPageEntityRequest<Runtimedependency, RuntimedependencyRequest>{

    protected ContextPath contextPath;

    public RuntimedependencyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Runtimedependency.class, cp -> new RuntimedependencyRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
