package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Rollupfield;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RollupfieldRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RollupfieldCollectionRequest extends CollectionPageEntityRequest<Rollupfield, RollupfieldRequest>{

    protected ContextPath contextPath;

    public RollupfieldCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Rollupfield.class, cp -> new RollupfieldRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest rollupfield_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("rollupfield_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest rollupfield_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("rollupfield_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest rollupfield_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("rollupfield_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest rollupfield_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("rollupfield_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest rollupField_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("RollupField_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest rollupField_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("RollupField_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
